<?php 

/**
* Класс для работы с аттачами сообщений
*/
class Attachments 
{
    // Массив с прикрепленными файлами в сессии 
    public $files = array();
    public $location = '';
    
    public function __construct($location) {
        if (isset($_SESSION[$location]['attachments'])) {
            $this->files = $_SESSION[$location]['attachments'];
        }
        $this->location = $location;
    }
    
    /**
    * Метод для вывода списка прикрепленных файлов
    * Callback nипа файла
    * @return
    */
    public function get_list() {
        $list = array();
        foreach($this->files AS $type => $files) {
             $list[$type] = call_user_func(array(&$this, 'get_list_' . $type));
        }
        
        $list = implode('', $list);
        
        if ($list) {
          return '<div class="attachments">' . $list . '</div>';
        }
    }
    
    protected function get_list_photo() {
        $html = array();
        
        foreach($this->files['photo'] AS $key => $file) {
            $html[] = '<div class="attachments-list">';
            $html[] = '<a href="' . $file['fileUrl'] . '">';
            $html[] = '<img src="' . $file['screenPatch'] . '" title="' . text($file['fileName']) . '" />';
            $html[] = '</a>';
            $html[] = '<a class="attachments-delete" href="/user/attachments/?location=' . $this->location . '&amp;type=photo&amp;delete=' . $key . '"><img src="/style/icons/cross.png" /></a>';
            $html[] = '</div>';
        }
        
        if ($html) {
            return '<div class="attachments-photo">'. implode('', $html) . '</div>';
        }
    }
}